<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml2/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <meta http-equiv="Content-Style-Type" content="text/css">
        <meta http-equiv="Content-Script-Type" content="text/javascript">
<script src="js/calculator.js" type="text/javascript"></script>
<link rel="stylesheet" href="css/calculatorsStyle.css" type="text/css" media="screen">
<meta name="description" content="Real Estate Calculators :: Compute Loan Amounts, Loan Terms, Loan Repayment Schedules, Loan Qualification and Rent vs. Buying">
<meta name="keywords" content="calculators,real estate calculators,rent vs. buy,loan amount,loan term,loan repayment,realty calculators,loan calculators">
<title>Calculators</title>
<link rel="stylesheet" type="text/css" href="ajaxtabs/ajaxtabs.css" />
<script type="text/javascript" src="ajaxtabs/ajaxtabs.js">
/***********************************************
* Ajax Tabs Content script v2.2-  Dynamic Drive DHTML code library (www.dynamicdrive.com)
* This notice MUST stay intact for legal use
* Visit Dynamic Drive at http://www.dynamicdrive.com/ for full source code
***********************************************/
</script>
</head>

<body>

<script language="JavaScript" type="text/JavaScript" src="js/floor.js"></script>
<script language="JavaScript" type="text/JavaScript" src="js/getMonthlyPayment.js"></script>
<script language="JavaScript" type="text/JavaScript" src="js/PMICalculator.js"></script>
<script language="JavaScript" type="text/JavaScript" src="js/AmortScheduleCalculator.js"></script>
<script language="JavaScript" type="text/JavaScript" src="js/EstimatedClosingCosts.js"></script>
<script language="JavaScript" type="text/JavaScript" src="js/RentVsBuyCalculator.js"></script>
<script language="JavaScript" type="text/JavaScript" src="js/commasDecimals.js"></script>

<script language="JavaScript" type="text/JavaScript">

//Declaration of Global Variables
var currentMonthlyRent = new Number(0);
var expectedYearlyRentIncrease = new Number(0);
var federalIncomeTaxBracket = new Number(0);
var termOfLoanInYears = new Number(0);
var loanRate = new Number(0);
var expectToBorrow = new Number(0);
var expectedPropertyPurchasePrice = new Number(0);
var estimatedAnnualAppreciation = new Number(0);
var yearlyPropertyTaxes = new Number(0);
var plannedYearsToOccupy = new Number (0);
var downPayment = new Number(0);
var discountPoints = new Number(0);
var annualMiscOwnershipFees = new Number(0.0);
var annualMiscRentalFees = new Number(0.0);

//Declare results variables
var estimatedCostsOfRenting, estimatedGrossCostsOfBuying, estimatedTaxRelatedSavings, estimatedIncreasedEquity, estimatedNetCostsOfBuying, estimatedTotalSavings, estimatedInvestmentRelatedSavings = "";

function calculate()
{
  //Set variables to current values, overstate Numbers (parseInt or parseFloat) as .value is a string
  currentMonthlyRent = parseInt(document.rentvsbuy.rent_buy_monthly_rent.value);

  termOfLoanInYears = parseInt(document.rentvsbuy.rent_buy_loan_term.options[document.rentvsbuy.rent_buy_loan_term.selectedIndex].value);
  expectToBorrow = parseInt(document.rentvsbuy.rent_buy_loan_amount.value);
  expectedPropertyPurchasePrice = parseInt(document.rentvsbuy.rent_buy_purchase_price.value);
  yearlyPropertyTaxes = parseInt(document.rentvsbuy.rent_buy_property_taxes.value);
  plannedYearsToOccupy = parseInt(document.rentvsbuy.rent_buy_years_home.value);
  downPayment = expectedPropertyPurchasePrice - expectToBorrow;

  //set these next few to decimals
  expectedYearlyRentIncrease = parseFloat((document.rentvsbuy.rent_buy_expected_increase.value)/100);
  federalIncomeTaxBracket = parseFloat((document.rentvsbuy.rent_buy_tax_bracket.options[document.rentvsbuy.rent_buy_tax_bracket.selectedIndex].value)/100);
  loanRate = parseFloat((document.rentvsbuy.rent_buy_interest_rate.value)/100);
  estimatedAnnualAppreciation = parseFloat((document.rentvsbuy.rent_buy_annual_appreciation.options[document.rentvsbuy.rent_buy_annual_appreciation.selectedIndex].value)/100);

  var RBCalc = new RentVsBuyCalculator();
  RBCalc = RBCalc.calculate(expectedPropertyPurchasePrice, loanRate, expectToBorrow, termOfLoanInYears*12, PMICalculator(expectToBorrow,downPayment), federalIncomeTaxBracket, estimatedAnnualAppreciation, discountPoints, plannedYearsToOccupy, currentMonthlyRent, expectedYearlyRentIncrease, yearlyPropertyTaxes, annualMiscOwnershipFees, annualMiscRentalFees);


  estimatedGrossCostsOfBuying = (floor(RBCalc.getGrossCosts()).toString());
  estimatedCostsOfRenting = (floor(RBCalc.getRentingCost()).toString());
  estimatedTaxRelatedSavings = (floor(RBCalc.getTaxSavings()).toString());
  estimatedIncreasedEquity = (floor(RBCalc.getEquityEarned()).toString());
  estimatedNetCostsOfBuying = (floor(estimatedGrossCostsOfBuying - estimatedTaxRelatedSavings - estimatedIncreasedEquity).toString());
  estimatedTotalSavings = (floor(RBCalc.getOwnershipBenefit()).toString());
  estimatedInvestmentRelatedSavings = (floor(RBCalc.getPotentialSavings()).toString());
  closingCosts = (floor(RBCalc.getClosingCosts()).toString());
}

//Browsercheck
var ie = document.all?1:0;
var n = document.layers?1:0;
//This checks for Netscape 6.2 or Greater
var gecko = ((navigator.appName == "Netscape")&&((navigator.appVersion.substring(0,3)==5)||(navigator.appVersion.substring(0,3)>5)))?1:0;

function makeChangeResultsObj(obj)
{
    this.writeref = (n) ? eval('document.'+ obj +'.document') : eval(obj);
    this.writeIt = b_writeIt;
}

function b_writeIt(text)
{
  if(n)
    {
      this.writeref.write(text);
      this.writeref.close();
    }
  else if(ie)
    {
     this.writeref.innerHTML=text;
    }

  //ADDED FOR 6.X COMPLIANCE - NEW CHANGE METHOD
  else if(gecko)
    {
     this.innerHTML=text;
    }
}

function showResults()
{
  estimatedCostsOfRenting = commasDecimals(estimatedCostsOfRenting);
  estimatedGrossCostsOfBuying = commasDecimals(estimatedGrossCostsOfBuying);
  estimatedTaxRelatedSavings = commasDecimals(estimatedTaxRelatedSavings);
  estimatedIncreasedEquity = commasDecimals(estimatedIncreasedEquity);
  estimatedNetCostsOfBuying = commasDecimals(estimatedNetCostsOfBuying);
  estimatedTotalSavings = commasDecimals(estimatedTotalSavings);
  estimatedInvestmentRelatedSavings = commasDecimals(estimatedInvestmentRelatedSavings);


	//BUILDS RESULTS
	var changeMsg =
	"<TABLE CELLPADDING=\"0\" CELLSPACING=\"0\" BORDER=\"0\" width=\"100%\">" +
	"  <TR ALIGN=\"left\" VALIGN=\"top\">" +
	"  <td class=\"inside\" colspan=\"5\" height=\"30\" valign=\"middle\">" +
	"<div class='bold_txt'>Your results</div>" +
	"<table width='100%' cellspacing='0' cellpadding='0' height='5'><tr><td bgcolor='#dee6ed'><img src='images/spacer.gif' width='1' height='3' border='0'></td></tr></table>" +
	"</td>" +
	"  <TR ALIGN=\"left\" VALIGN=\"top\">" +
	"    <TD COLSPAN=\"5\" HEIGHT=\"30\" VALIGN=\"MIDDLE\" CLASS=\"small_txt\">Based on the information you provided, the following represents your costs and savings over the next 30 years.</TD>" +
	"  </TR>" +
	"  <tr><td colspan='5' ><img src='images/spacer.gif' width='430' height='1'></td></tr>" +
	"  <TR ALIGN=\"left\" VALIGN=\"top\">" +
	"    <TD VALIGN=\"top\" class=\"small_txt\">Estimated costs of renting:</TD>" +
	"    <TD width=\"10\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"10\" HEIGHT=\"1\"></td>" +
	"	 <td valign=\"top\" class=\"small_txt\"></td>" +
	"	 <td width=\"80\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"80\" HEIGHT=\"2\">" +
	"	 <td class=\"small_txt\" valign=\"top\" id=\"estimatedCostsOfRenting\">$" + estimatedCostsOfRenting + "</TD>" +
	"  </TR>" +
	"  <tr><td class=\"rowUnderline\" colspan='5' ><img src='images/spacer.gif' width='430' height='1'></td></tr>" +
	"  <TR ALIGN=\"left\" >" +
	"    <TD VALIGN=\"top\" class=\"small_txt\">Estimated gross costs of buying: (includes $" + closingCosts + " in closing costs)</TD>" +
	"    <TD width=\"10\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"10\" HEIGHT=\"1\"></td>" +
	"	 <td valign=\"top\" class=\"small_txt\"></td>" +
	"	 <td width=\"80\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"80\" HEIGHT=\"2\">" +
	"	 <td class=\"small_txt\" valign=\"top\" id=\"estimatedGrossCostsOfBuying\">$" + estimatedGrossCostsOfBuying + "</TD>" +
	"  </TR>" +
	"  <tr><td class=\"rowUnderline\" colspan='5' ><img src='images/spacer.gif' width='430' height='1'></td></tr>" +
	"  <TR ALIGN=\"left\">" +
	"    <TD VALIGN=\"top\" class=\"small_txt\">Estimated amount of tax related savings:</TD>" +
	"    <TD width=\"10\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"10\" HEIGHT=\"1\"></td>" +
	"	 <td valign=\"top\" class=\"small_txt\"></td>" +
	"	 <td width=\"80\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"80\" HEIGHT=\"2\">" +
	"	 <td class=\"small_txt\" valign=\"top\" id=\"estimatedTaxRelatedSavings\">$" + estimatedTaxRelatedSavings + "</TD>" +
	"  </TR>" +
	"  <tr><td class=\"rowUnderline\" colspan='5' ><img src='images/spacer.gif' width='430' height='1'></td></tr>" +
	"  <TR ALIGN=\"left\" VALIGN=\"top\">" +
	"    <TD VALIGN=\"top\" class=\"small_txt\">Estimated amount in increased equity:</TD>" +
	"    <TD width=\"10\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"10\" HEIGHT=\"1\"></td>" +
	"	 <td valign=\"top\" class=\"small_txt\"></td>" +
	"	 <td width=\"80\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"80\" HEIGHT=\"2\">" +
	"	 <td class=\"small_txt\" valign=\"top\" id=\"estimatedIncreasedEquity\">$" + estimatedIncreasedEquity + "</TD>" +
	"  </TR>" +
	"  <tr><td class=\"rowUnderline\" colspan='5' ><img src='images/spacer.gif' width='430' height='1'></td></tr>" +
	"  <TR ALIGN=\"left\" VALIGN=\"top\">" +
	"    <TD VALIGN=\"top\" class=\"small_txt\">Estimated net costs of buying:</TD>" +
	"    <TD width=\"10\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"10\" HEIGHT=\"1\"></td>" +
	"	 <td valign=\"top\" class=\"small_txt\"></td>" +
	"	 <td width=\"80\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"80\" HEIGHT=\"2\">" +
	"	 <td class=\"small_txt\" valign=\"top\" id=\"estimatedNetCostsOfBuying\">$" + estimatedNetCostsOfBuying + "</TD>" +
	"  </TR>" +
	"  <tr><td class=\"rowUnderline\" colspan='5'><img src='images/spacer.gif' width='430' height='5'></td></tr>" +
	"  <TR ALIGN=\"left\" VALIGN=\"top\">" +
	"    <TD VALIGN=\"top\" class=\"small_txt\"><B>Estimated total savings:</B> (not including investment related savings)</TD>" +
	"    <TD width=\"10\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"10\" HEIGHT=\"1\"></td>" +
	"	 <td valign=\"top\" class=\"small_txt\"></td>" +
	"	 <td width=\"80\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"80\" HEIGHT=\"2\">" +
	"	 <td class=\"small_txt\" valign=\"top\" id=\"estimatedTotalSavings\">$" + estimatedTotalSavings + "</TD>" +
	"  </TR>" +
	"  <tr><td class=\"rowUnderline\" colspan='5' ><img src='images/spacer.gif' width='430' height='1'></td></tr>" +
	"  <TR ALIGN=\"left\" VALIGN=\"top\">" +
	"    <TD VALIGN=\"top\" class=\"small_txt\">Estimated investment related savings:</TD>" +
	"    <TD width=\"10\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"10\" HEIGHT=\"1\"></td>" +
	"	 <td valign=\"top\" class=\"small_txt\"></td>" +
	"	 <td width=\"80\"><IMG SRC=\"images/dotclear.gif\" WIDTH=\"80\" HEIGHT=\"2\">" +
	"	 <td class=\"small_txt\" valign=\"top\" id=\"estimatedInvestmentRelatedSavings\">$" + estimatedInvestmentRelatedSavings + "</TD>" +
	"  </TR>" +
	"</TABLE>";

    if(ie || n)
    {
      oMessage=new makeChangeResultsObj('objResults');
      oMessage.writeIt(changeMsg);
    }

      //ADDED FOR 6.X COMPLIANCE - NEW CHANGE METHOD
    else if (gecko)
    {
      var results = document.getElementById("objResults");
      results.writeIt = b_writeIt;
      results.writeIt(changeMsg);
    }
}
</script>

<!-- FORM VALIDATION -->
<script language="JavaScript" type="text/JavaScript">
function isBlank(data)
{
  if (data.length == 0)
      return 1;

  for (i = 0; i < (data.length); i++)
    {
      if (data.charAt(i) != " ")
        return 0;
    }

  return 1;
}

function isNumOnly(data)
{
  var i = new Number(data.length);
  var j = new Number(0);
  var k = new Number();

  for (j=0; j < i; j++)
    {
      if ((isNaN(data.charAt(j)) == true))
	    return 0;
    }
    return 1;
}

function isInvalidCharacter(data)
{
  for (i=0; i < data.length; i++)
    {
      if ((data.charAt(i)=="~")||(data.charAt(i)=="!")||(data.charAt(i)=="@")||(data.charAt(i)=="#")
        ||(data.charAt(i)=="$")||(data.charAt(i)=="%")||(data.charAt(i)=="^")||(data.charAt(i)=="&")
        ||(data.charAt(i)=="*")||(data.charAt(i)=="(")||(data.charAt(i)==")")||(data.charAt(i)=="_")
        ||(data.charAt(i)=="+")||(data.charAt(i)=="=")||(data.charAt(i)=="{")||(data.charAt(i)=="[")
        ||(data.charAt(i)=="|")||(data.charAt(i)=="<")||(data.charAt(i)==",")||(data.charAt(i)==">")
        ||(data.charAt(i)=="}")||(data.charAt(i)=="]")||(data.charAt(i)=="?")||(data.charAt(i)=="/"))
        {
          return 1;
        }
    }
  return 0;
}

function isAlphaOnly(data, characterTest, spaceTest)
{
  i = new Number(data.length);
  j = new Number(0);

  if (characterTest == 0)
    {
      if (isInvalidCharacter(data) == 1)
          return 0;
    }

  if (spaceTest == 0)
    {
      for (j=0; j < i; j++)
        {
          if (data.charAt(j) == " ")
              return 0;
        }
    }

  for (j=0; j < i; j++)
    {
      if (isNaN(data.charAt(j)) == false)
	  return 0;
    }
  if ((j==i)&&(i!=0))
      return 1;
}

function isExactLength(data, num)
{

  var howLong = new Number(data.length);
  var rightLength = new Number(num);

  return ((howLong < rightLength)||(howLong > rightLength));
}


function isMinAndMaxLength(data, min, max)
{
  var minimum = new Number(min);
  var maximum = new Number(max);

  return ((data.length < minimum) || (data.length > maximum));
}


function isBetweenMinAndMax(data, min, max)
{
  return ((data < min)||(data > max));
}
</script>

<script language="JavaScript" type="text/JavaScript">
function checkForm(form)
{
  var errorMsg = "";
  var i;
  var message = new Array();
  var inputs = new Array(form.length);

  var rent, annualincrease, interestrate, loanamount, purchaseprice, propertytax,
      yearsinhome = "";

  for (i = 0; i < form.length; i++)
    {
       inputs[i] = form.elements[i].name;
    }

  for (i = 0; i < form.length; i++)
    {
      if (inputs[i] == "rent_buy_monthly_rent")
          rent = i;
      else if (inputs[i] == "rent_buy_expected_increase")
          annualincrease = i;
      else if (inputs[i] == "rent_buy_interest_rate")
          interestrate = i;
      else if (inputs[i] == "rent_buy_loan_term")
          loanterm = i;
      else if (inputs[i] == "rent_buy_loan_amount")
          loanamount = i;
      else if (inputs[i] == "rent_buy_purchase_price")
          purchaseprice = i;
      else if (inputs[i] == "rent_buy_property_taxes")
          propertytax = i;
      else if (inputs[i] == "rent_buy_years_home")
          yearsinhome = i;
    }


  message[0] = "Please enter your monthly rent.\n";
  message[1] = "Your monthly rent should be free of special characters or letters.\n";
  message[2] = "Your monthly rent should be greater than $0 and less than $1,000,000,000.\n";
  message[3] = "Please enter your expected annual rent increase.\n";
  message[4] = "The value for expected annual rent increase should be free of special characters or\n" +
               "letters.\n";
  message[5] = "Your expected annual rent increase should be between 0% and 10%.\n";
  message[6] = "Please enter an interest rate.\n";
  message[7] = "Your interest rate value should be free of special characters or letters.\n";
  message[8] = "Your interest rate value should be greater than 0% and less than 51%.\n";
  message[9] = "Please enter a value for loan amount.\n";
  message[10] = "Your loan amount should be free of special characters or letters.\n";
  message[11] = "Your loan amount should be greater than $20000.\n";
  message[12] = "Please enter a value for purchase price.\n";
  message[13] = "Your purchase price should be free of special characters or letters.\n";
  message[14] = "Your purchase price should be greater than or equal to \n" +
		"your loan amount and less than $1,000,000,000.\n";
  message[15] = "Your purchase price should be greater than or equal to your loan amount.\n";
  message[16] = "Your proposed property taxes should be free of letters and special characters.\n";
  message[17] = "The value of your proposed property taxes must be a minimum of $0 and\n" +
                "less than or equal to $1,000,000,000.\n";
  message[18] = "Please enter the number of years you plan to be in your home.\n";
  message[19] = "The number of years you plan to be in this home should be\n" +
		"free of letters or special characters.\n";
  message[20] = "The number of years you plan to be in this home should be greater\n" +
                "than 0 and less than or equal to the term of the loan.\n";


  if (isBlank(form.elements[rent].value) == 1)
      errorMsg += message[0];
  else if (isNaN(form.elements[rent].value) == true)
      errorMsg += message[1];
  else if ((form.elements[rent].value <= 0)||(form.elements[rent].value >= 1000000000))
      errorMsg += message[2];

  if (isBlank(form.elements[annualincrease].value) == 1)
	  errorMsg += message[3];
  else if (isNaN(form.elements[annualincrease].value) == true)
          errorMsg += message[4];
  else if (isBetweenMinAndMax(form.elements[annualincrease].value, 0, 10) == 1)
          errorMsg += message[5];


  if (isBlank(form.elements[interestrate].value) == 1)
      errorMsg += message[6];
  else if (isNaN(form.elements[interestrate].value) == true)
      errorMsg += message[7];
  else if ((form.elements[interestrate].value <= 0)||(form.elements[interestrate].value >= 51))
      errorMsg += message[8];

  if (isBlank(form.elements[loanamount].value) == 1)
      errorMsg += message[9];
  else if (isNaN(form.elements[loanamount].value) == true)
      errorMsg += message[10];
  else if ((form.elements[loanamount].value < 20000)||(form.elements[loanamount].value >= 1000000000))
      errorMsg += message[11];
  else
      var lamount = new Number(form.elements[loanamount].value);

  if (isBlank(form.elements[purchaseprice].value) == 1)
      errorMsg += message[12];
  else if (isNaN(form.elements[purchaseprice].value) == true)
      errorMsg += message[13];
  else if ((form.elements[purchaseprice].value < 20000)||(form.elements[purchaseprice].value > 1000000000))
      errorMsg += message[14];
  else
      var pprice = new Number(form.elements[purchaseprice].value);

  if((isBlank(form.elements[loanamount].value) == 0)&&(isNaN(form.elements[loanamount].value) == false)&&(form.elements[loanamount].value > 0)&&(form.elements[loanamount].value < 1000000000)&&(isBlank(form.elements[purchaseprice].value) == 0)&&(isNaN(form.elements[purchaseprice].value) == false)&&(form.elements[purchaseprice].value >= 20000)&&(form.elements[purchaseprice].value <= 1000000000)&&(lamount > pprice))
      errorMsg += message[15];

  if (isBlank(form.elements[propertytax].value) == 0)
    {
      if (isNaN(form.elements[propertytax].value) == true)
          errorMsg += message[16];
      else if ((form.elements[propertytax].value < 0)||(form.elements[propertytax].value > 1000000000))
          errorMsg += message[17];
    }

var yrsinhome = new Number(form.elements[yearsinhome].value);

  if (isBlank(form.elements[yearsinhome].value) == 1)
      errorMsg += message[18];
  else if (isNaN(form.elements[yearsinhome].value) == true)
      errorMsg += message[19];
  else if (form.elements[yearsinhome].value <= 0)
      errorMsg += message[20];
  else if (yrsinhome > form.elements[loanterm].options[form.elements[loanterm].selectedIndex].value)
      errorMsg += message[20];

//No need to return anything here
  if (errorMsg.length == 0)
    {
//If there's no error message, calculate
      calculate();
      showResults();
    }
  else
    {
//If there's an error message, just show it
      alert("Before continuing, the following fields require attention:\n\n" + errorMsg);
    }

}
</script>
<!-- END CALCULATOR -->
<img style="float: left; margin-right: 10px;" src="images/calculatorsIcon.jpg" align="absmiddle"> <h2>Calculators</h2>

<br />

<ul id="countrytabs" class="shadetabs">
<li><a href="#" rel="#default" class="selected">Loan Term</a></li>

<li><a href="loan-qualifier.html" rel="countrycontainer" >Loan Qualifier</a></li>
<li><a href="loan-amount.html" rel="countrycontainer">Qualified Amount</a></li>
<li><a href="loan-repayment.html" rel="countrycontainer">Monthly Payments</a></li>
<li><a href="rent_vs_buy_calc.html" rel="countrycontainer">Rent vs. Buy</a></li>
</ul>

<div id="countrydivcontainer" style="border:1px solid gray; width:600px; margin-bottom: 1em; padding: 10px; -moz-border-radius: 12px; -webkit-border-radius: 12px; background-image: url('images/tabbed-body-bg.jpg'); background-position: bottom left; background-repeat: repeat-x;">
   <h1>Loan Term Calculator</h1>


<!-- Start Content -->

	<p><b>How long will it take to repay my loan?</b><br />
	<img src="images/horizontal-line.gif">
	<br />
	Providing a loan amount, regular repayment amount and an annual interest rate, this calculator provides the approximate years and months it will take to repay the loan.</p>

	<form id="repay" method="post" action="#">
	<table cellspacing="0" cellpadding="2" border="0">
	<tr>
	<td valign="top">Loan amount</td>
	<td valign="top" rowspan="3" style="height:1px;"></td>
	<td valign="top"><input onblur="checkLoan(LoanAmt2);" size="12" value="100000" name="LoanAmt2" /> [$]</td>
	</tr>
	<tr>
	<td valign="top">Regular repayment amount</td>
	<td valign="top"><input onblur="checkRepay(RepayAmt2);" size="12" value="700" name="RepayAmt2" />
	<select name="RepayFreq">
	<option value="12" selected="selected">per month</option>
	<option value="26">per fortnight</option>
	<option value="52">per week</option>
	</select>
	</td>
	</tr>
	<tr>
	<td valign="top">Annual interest rate</td><td valign="top"><input size="12" value="7.00" name="IntRate2" onblur="checkIntRate(IntRate2);" /> [%]</td>
	</tr>
	</table>

	<table cellspacing="2" cellpadding="2" width="100%" border="0">
	<tr>
	<td valign="baseline" align="right"><a class="submitCalculation" href="#results" onclick="CalcTerm();" name="Calculate">
			<img src="images/calculate.png" border="0" height="31" width="87"></a></td>
	</tr>
	<tr>
	<td valign="top" align="right"><b>It will take <input size="5"  name="TermYear2" /> years and <input size="5" name="TermMonth2" />months to repay the loan amount.</b></td>
	</tr>
	</table>
</form>
<!-- End Content -->
</div>

<script type="text/javascript">
var countries=new ddajaxtabs("countrytabs", "countrydivcontainer")
countries.setpersist(true)
countries.setselectedClassTarget("link") //"link" or "linkparent"
countries.init()
</script>

<div id="calculatorsDisclaimer">These calculators and the resulting calculations do not constitute a loan application, loan offer or loan approval.</div>




</body>
</html>