//Within this file lives the constructor, the calculate, and the accessor 
//methods for EstimatedClosingCosts
//Note:  I DID NOT overload the calculate function

function EstimatedClosingCosts()
{
  //Define variables
  this.className = "EstimatedClosingCosts";

  this.calculate = EstimatedClosingCostCalculate;

  return this;
}

function EstimatedClosingCostCalculate(loanAmt, loanTerm, interestRate, programPoints, downPaymentAmt, closingDate)
{

  //Define Local Variables
  var TAXSERVICEFEE = new Number(75);
  var FEETOCHARGE = new Number (350);
  var CREDITREPORTFEE = new Number(20.7);
  var APPRAISALFEE = new Number(300);
  var FLOODCERTFEE = new Number(15.5);
  var DEFAULTRATE = new Number(0.08);
  var DEFAULTLOANAMT = new Number(100000);
  var DEFAULTTERM = new Number(360);
  var DEFAULTINTERESTDAYS = new Number(15);

  var today = new Date();

  //Approximate the Loan Amount, if none passed in
  if (loanAmt == null)
    {
      var loanAmt = new Number(DEFAULTLOANAMT);
    }        
  
  //Determine LoanType and Term, if possible
  if (loanTerm == null)
    {
      var loanTerm = new Number(DEFAULTTERM);
    }
    
  //Determine Mortgage Insurance, based on LTV
  if (downPaymentAmt == null)
    {
      var downPaymentAmt = new Number(0);
    }

  if (interestRate == null)
    {
      var interestRate = new Number(DEFAULTRATE);
    }
  
  // Calculate any MI
  var monthlyMI = new Number(PMICalculator(loanAmt,downPaymentAmt));

  // 2 months prepaid MI
  var MIFee = new Number(2*monthlyMI);

  var interestDays = DEFAULTINTERESTDAYS;

  if (closingDate != null)
    {            
      interestDays = today.getDate();
    }

  var prePaidInterest = new Number(interestRate/365 * loanAmt * interestDays);
  
  // determine origination fee
  var originationFee = new Number(0);
  if (programPoints == null)
    {
      programPoints = new Number(0);
    }
  else if ((programPoints > 0.01)||(programPoints == 0.01))
    {
      originationFee = 0.01 * loanAmt;
    }

  // determine discount points
  var discountPoints = new Number(0);
  if (programPoints > .01)
    {
      discountPoints = (programPoints - 0.01) * loanAmt;
    }
  else if ((programPoints > 0)&&(programPoints < 0.01))
    {
      discountPoints = programPoints * loanAmt;
    }

  var paidByLender = new Number(0);
  if (programPoints < 0.0)
    {
      paidByLender = programPoints * loanAmt;
    }

  return (TAXSERVICEFEE + FEETOCHARGE + CREDITREPORTFEE + APPRAISALFEE + FLOODCERTFEE + paidByLender + discountPoints + originationFee + prePaidInterest + MIFee);

}