//This is the constructor, the calculate method and the accessor methods
//for the RentVsBuyCalculator

//Define global variables
var DEFAULT_INVESTMENT_RATE = new Number(0.08);

//ownership benefit accessor method
function getOwnershipBenefit()
{
  if ((this.rentingCost - this.ownershipCost) >0)
    {
      return (this.rentingCost - this.ownershipCost);
    }
  else
    {
      return 0;
    }
}

//renting cost accessor method
function getRentingCost()
{
  return this.rentingCost;
}

//ownership cost accessor method
function getOwnershipCost()
{
  return this.ownershipCost;
}

//tax savings accessor method
function getTaxSavings()
{
  return this.taxSavings;
}

//closing costs accessor method
function getClosingCosts()
{
  return this.closingCosts;
}

//gross costs accessor method
function getGrossCosts()
{
  return this.grossCosts;
}

//equity earned accessor method
function getEquityEarned()
{
  return this.equityEarned;
}

//potential savings accessor method
function getPotentialSavings()
{
  return ((this.rentingCost - this.ownershipCost) * DEFAULT_INVESTMENT_RATE);
}

//this method is the new AmortScheduleCalculator object constructor
function RentVsBuyCalculator()
{
  //variables
  this.rentingCost = new Number();
  this.ownershipCost = new Number();
  this.taxSavings = new Number();
  this.closingCosts = new Number();
  this.equityEarned = new Number();
  this.grossCosts = new Number();
  this.className = "RentVsBuyCalculator";

  //methods
  this.getOwnershipBenefit = getOwnershipBenefit;
  this.getRentingCost = getRentingCost;
  this.getTaxSavings = getTaxSavings;
  this.getClosingCosts = getClosingCosts;
  this.getGrossCosts = getGrossCosts;
  this.getEquityEarned = getEquityEarned;
  this.getPotentialSavings = getPotentialSavings;
  this.calculate = RentVsBuyCalculatorCalculate;
  
  return this;
}



// this is the calculate method
function RentVsBuyCalculatorCalculate (salesPrice, interestRate, loanAmt, loanTerm, monthlyMI, federalTaxRate, appreciationRate, discountPoints, expectedYearsToOwn, monthlyRent, annualRentIncrease, annualPropertyTax, annualMiscOwnershipFees, annualMiscRentalFees)
{
  var totalAppreciation = new Number(0);
  var totalPrincipalPaid = new Number(0);
  var totalInterestPaid = new Number(0);
  var totalPMI = new Number(0);
  var year = new Number(0);

  var rvb = new RentVsBuyCalculator();

  var amort = new AmortScheduleCalculator();
  amort = amort.calculate(loanAmt,salesPrice,interestRate,0,0,1,expectedYearsToOwn*12,0,0,0,0,federalTaxRate,monthlyMI,false,loanTerm,loanTerm,0,0,0,0,0,0);

  totalPrincipalPaid = amort.getTotalNormalPrincipal();        
  totalInterestPaid = amort.getTotalNormalInterest();        
  totalPMI = amort.getTotalPMI();        
  var annualRent = monthlyRent * 12;

  // Forcast appreciation/increases
    for (year = 0; year < expectedYearsToOwn; year++)
      {
        // Calculate all of the rental costs for the term expected
        rvb.rentingCost += annualRent;
        annualRent += annualRent * annualRentIncrease;
                 
        // Calculate the annual appreciation in equity
        if (year > 0)
          {
            totalAppreciation += salesPrice * appreciationRate;
          }
      }

  rvb.rentingCost += (annualMiscRentalFees * expectedYearsToOwn);

  rvb.equityEarned = (salesPrice + totalAppreciation + totalPrincipalPaid - loanAmt);


  // Calculate annual property tax if not passed, use 1.5% as default
  //   if (annualPropertyTax == 0)
  //       annualPropertyTax = ( salesPrice * DEFAULT_PROPERTY_TAX_RATE );

  // Calculate total tax savings (interest, property tax, closing costs)
  var totalPropertyTax = new Number(annualPropertyTax * expectedYearsToOwn);

  rvb.taxSavings = amort.getTotalTaxSavings() + (totalPropertyTax * federalTaxRate) + (discountPoints * loanAmt * federalTaxRate);

  // Get closing costs
  var closingTemp = new EstimatedClosingCosts();
  
  rvb.closingCosts = closingTemp.calculate(loanAmt, loanTerm, interestRate, discountPoints, (salesPrice - loanAmt));

  rvb.ownershipCost = (totalInterestPaid + totalPrincipalPaid + totalPMI + totalPropertyTax + rvb.closingCosts + (annualMiscOwnershipFees * expectedYearsToOwn)) - (rvb.taxSavings + rvb.equityEarned);
                                
  rvb.grossCosts= (totalInterestPaid + totalPrincipalPaid + totalPMI + totalPropertyTax + rvb.closingCosts + (annualMiscOwnershipFees * expectedYearsToOwn));

  return rvb;
}