/*
   String Tokenizer
   Split up a material string based upong the separator.
*/
function StringTokenizer (material, separator)
{
   // Attributes.
   this.material = material;
   this.separator = separator;

   // Operations.
   this.getTokens = stGetTokens;
   this.nextToken = stNextToken;
   this.countTokens = stCountTokens;
   this.hasMoreTokens = stHasMoreTokens;
   this.tokensReturned = stTokensReturned;

   // Initialisation code.
   this.tokens = this.getTokens();
   this.tokensReturned = 0;
}

function stGetTokens()
{
   var tokens = new Array();
   var nextToken;

   	if (this.material.indexOf (this.separator) < 0) {
		tokens [0] = this.material;
		return tokens;
	}

   start = 0;
   end = this.material.indexOf (this.separator, start);

   // Counter for how many tokens were found.
   var counter = 0;

   // Go through material, token at a time.
   var trimmed;
 	while (this.material.length - start >= 1)
	{
		nextToken = this.material.substring (start, end);
		start = end + 1;
		if (this.material.indexOf (this.separator, start + 1) < 0) {
			end = this.material.length;
		} else {
			end = this.material.indexOf (this.separator, start + 1);
		}

      trimmed = stTrim (nextToken);

      // Remove any extra separators at start.
      while (trimmed.substring(0, this.separator.length) == this.separator) {
         trimmed = trimmed.substring (this.separator.length);
      }
      trimmed = stTrim(trimmed);
      if (trimmed == "") {
         continue;
      }
      tokens [counter] = trimmed;
	  counter ++;
	}

   // Return the initialised array.
   return tokens;
}

function stCountTokens()
{
  return this.tokens.length;
}

function stNextToken()
{
   if (this.tokensReturned >= this.tokens.length) {
      return null;
   } else {
      var returnToken = this.tokens [this.tokensReturned];
      this.tokensReturned ++;
      return returnToken;
   }
}

function stHasMoreTokens()
{
   if (this.tokensReturned < this.tokens.length) {
      return true;
   } else {
      return false;
   }
}

function stTokensReturned()
{
   return this.tokensReturned;
}

function stTrim (strToTrim) {
   return(strToTrim.replace(/^\s+|\s+$/g, ''));
}


/**
* validateRequired()
* @param    HTMLElement form
*/
function validateRequired1(form){
    try{
        // Check form required fields
        for(var i = 0; i < form.elements.length; i++){
            // Get form element
            var element = form.elements[i];
            // Check if required element
            if(element.getAttribute('required')){

            }
        }
    }catch(e){}
}




function validateRequired(form) {
//alert(1);
    var bValid = true;
    var focusField = null;
    var i = 0;
    var fields = new Array();
    oRequired = new required();
    for (x in oRequired) {
        var field = form[oRequired[x][0]];
//      alert(field.id + ":" + field.type + " : " + field.length + ":" + field[0].type);

        if (field.type == 'text' ||
            field.type == 'textarea' ||
            field.type == 'file' ||
            field.type == 'select-one' ||
            field.type == 'radio' ||
            (field.length>0 && field[0].type == "radio") ||
            (field.length>0 && field[0].type == "checkbox") ||
            field.type == 'password') {
            
            var value = '';
            // get field's value
            if (field.type == "select-one") {
                var si = field.selectedIndex;
                if (si >= 0) {
                    value = field.options[si].value;
                }
                if (value == '0' ) value = '';
            } else
            if (field.length>0 && field[0].type == "radio") {
                var i2 = 0;
                var selectedIndex = 0;
                var valueSet = false;
                for (i2=0;i2<field.length;i2++){
                    if (field[i2].checked) {
                        valueSet = true;
                        selectedIndex = i2;
                        break;
                    }
                }
                if (!valueSet) value = '';
                else value = field[selectedIndex].value;
            } else
            if (field.length>0 && field[0].type == "checkbox") {
                var i2 = 0;
                var selectedIndex = 0;
                var valueSet = false;
                for (i2=0;i2<field.length;i2++){
                    if (field[i2].checked) {
                        valueSet = true;
                        selectedIndex = i2;
                        break;
                    }
                }
                if (!valueSet) value = '';
                else value = field[selectedIndex].value;
            } else {
                value = field.value;
            }
            
            if (value == '') {
            
                if (i == 0) {
                    if (field.length>0 && ((field[0].type == "radio")||(field[0].type == "checkbox"))) focusField = null
                    else focusField = field;
                }
                fields[i++] = oRequired[x][1];
                bValid = false;
            }
        }
    }
    if (fields.length > 0) {
       if (focusField!=null) focusField.focus();
       alert(fields.join('\n'));
    }

//alert(1);

//alert(bValid);
    return bValid;
}

function validateEmail(form) {
	var bValid = true;
	var focusField = null;
	var i = 0;
	var fields = new Array();
	oEmail = new email();
	for (x in oEmail) {
		if ((form[oEmail[x][0]].type == 'text' ||
			 form[oEmail[x][0]].type == 'textarea') &&
			(form[oEmail[x][0]].value.length > 0)) {
			if (!checkEmail(form[oEmail[x][0]].value)) {
				if (i == 0) {
					focusField = form[oEmail[x][0]];
				}
				fields[i++] = oEmail[x][1];
				bValid = false;
			}
		}
	}
	if (fields.length > 0) {
		focusField.focus();
		alert(fields.join('\n'));
	}
	return bValid;
}

function checkEmail(emailStr) {
   if (emailStr.length == 0) {
	   return true;
   }
	var tokenizer = new StringTokenizer (emailStr, ",");

   	while (tokenizer.hasMoreTokens())
   	{
		var email = tokenizer.nextToken();
		var emailPat=/^(.+)@(.+)$/;
		var specialChars="\\(\\)<>@,;:\\\\\\\"\\.\\[\\]";
		var validChars="\[^\\s" + specialChars + "\]";
		var quotedUser="(\"[^\"]*\")";
		var ipDomainPat=/^(\d{1,3})[.](\d{1,3})[.](\d{1,3})[.](\d{1,3})$/;
		var atom=validChars + '+';
		var word="(" + atom + "|" + quotedUser + ")";
		var userPat=new RegExp("^" + word + "(\\." + word + ")*$");
		var domainPat=new RegExp("^" + atom + "(\\." + atom + ")*$");
		var matchArray=email.match(emailPat);
		if (matchArray == null) {
		   return false;
		}
		var user=matchArray[1];
		var domain=matchArray[2];
		if (user.match(userPat) == null) {
		   return false;
		}
		var IPArray = domain.match(ipDomainPat);
		if (IPArray != null) {
		   for (var i = 1; i <= 4; i++) {
			  if (IPArray[i] > 255) {
				 return false;
			  }
		   }
		   return true;
		}
		var domainArray=domain.match(domainPat);
		if (domainArray == null) {
		   return false;
		}
		var atomPat=new RegExp(atom,"g");
		var domArr=domain.match(atomPat);
		var len=domArr.length;
		if ((domArr[domArr.length-1].length < 2) ||
		   (domArr[domArr.length-1].length > 3)) {
		   return false;
		}
		if (len < 2) {
		   return false;
		}
   }
   return true;
}


function validateNumeric(form) {
	var bValid = true;
	var focusField = null;
	var i = 0;
	var fields = new Array();
	oInteger = new numeric();
	for (x in oInteger) {
		var field = form[oInteger[x][0]];

		if (field.type == 'text' ||
			field.type == 'textarea' ||
			field.type == 'select-one' ||
			field.type == 'radio') {

			var value = '';
			// get field's value
			if (field.type == "select-one") {
				var si = field.selectedIndex;
				if (si >= 0) {
					value = field.options[si].value;
				}
			} else {
				value = field.value;
			}

			if (value.length > 0) {

				if (!isAllDigits(value)) {
						bValid = false;
						focusField = field;
						fields[i++] = oInteger[x][1];
				} else {
					var iValue = parseInt(value);
					// if (isNaN(iValue) || !(iValue >= -2147483648 && iValue <= 2147483647)) {
					if (isNaN(iValue)) {
						if (i == 0) {
							focusField = field;
						}
						fields[i++] = oInteger[x][1];
						bValid = false;
				   }
			   }
		   }
		}
	}
	if (fields.length > 0) {
	   focusField.focus();
	   alert(fields.join('\n'));
	}
	return bValid;
}

function isAllDigits(argvalue) {
  return validateChars(argvalue, "0123456789");
}
function isAllDigitsOrDash(argvalue) {
  return validateChars(argvalue, "0123456789-");
}

function isValidPhoneNumber(argvalue) {
	var phoneRegex = new RegExp("^([0-9]{10})|([0-9]{3}\\.[0-9]{3}\\.[0-9]{4})|([0-9]{3}-[0-9]{3}-[0-9]{4})");
	return phoneRegex.test(argvalue);
}

function validateChars(argvalue, validChars) {
	argvalue = argvalue.toString();
	var startFrom = 0;
	/*
	if (argvalue.substring(0, 2) == "0x") {
	   validChars = "0123456789abcdefABCDEF";
	   startFrom = 2;
	} else if (argvalue.charAt(0) == "0") {
	   validChars = "01234567";
	   startFrom = 1;
	}
	*/
	if (argvalue.substring(0,1) == "-")
		startFrom = 1;

	for (var n = startFrom; n < argvalue.length; n++) {
		if (validChars.indexOf(argvalue.substring(n, n+1)) == -1) return false;
	}

	return true;
}

function isValidZip(zip)
{
	zip = zip.trim();
	if (zip.length == 0) {
		return true;
	}
	
	if (zip.length == 5 && isAllDigits(zip)) {
		return true;
	}
	if (zip.length == 10 && isAllDigitsOrDash(zip) && (argvalue.substring(4,1)== "-")) {
		return true;
	}
	
	alert("Zip Code must be in this format 12345 or 12345-1234");
	return false;
}

function isValidPostalCode(postalCode)
{
	postalCode = postalCode.trim();
	if (postalCode.length == 0) {
		return true;
	}
    if (postalCode.length == 6) {
		return true;
	}

	alert("Postal Code must be 6 symbols long.");
	return false;
}
