/**
 * Prevent selecting "All" option with any other in multiselect input control
 * @author VVL
 * @param multiSelectCtrl - src input control to check
 */
function adjustMultiSelect(multiSelectCtrl){
   try{
        if (!multiSelectCtrl) return;
        // total options available
        var optionsCnt = multiSelectCtrl.options.length;
        // no need to adjust selection if only one option available
        if  (optionsCnt < 2) return;
        //check whether first and other options selected
        for (i = 1; i < optionsCnt; i++){
            if (multiSelectCtrl.options[i].selected && multiSelectCtrl.options[0].selected){
              //unselect first and exit
              multiSelectCtrl.options[0].selected=false;
              return;
            }
        }

     } catch (e){
           alert(" Error in adjustMultiSelect : "+e.description);
     }
}

function isMultipleSelected(multiSelectCtrl)
{
	if (!multiSelectCtrl) return false;
	// total options available
	var optionsCnt = multiSelectCtrl.options.length;
	// no need to adjust selection if only one option available
	if  (optionsCnt < 2) return false;
	var isSelected = false;
	//check whether first and other options selected
	for (i = 1; i < optionsCnt; i++){
		if (multiSelectCtrl.options[i].selected){
		  //unselect first and exit
		  if (isSelected) {
			return true;
		  }
		  isSelected = true;
		}
	}
	return false;
}

/* rollover for TDs and TRs */
function changeBack(toClass,fromClass,theState,theRow,theSibling){
	if(theSibling!=null){
		targetSibling = (theSibling=="+")? theRow.nextSibling : theRow.previousSibling;
		if(theState == 'over' && theRow.className == toClass && targetSibling.className == toClass){return;}
		if (theRow.className == fromClass && targetSibling.className == fromClass){
			theRow.style.cursor = 'pointer';
			theRow.className = toClass;
			targetSibling.className = toClass;
		}
		else{
			theRow.style.cursor = '';
			theRow.className = fromClass;
			targetSibling.className = fromClass;
		}
	}else {
		if(theState == 'over' && theRow.className == toClass){return;}
		if (theRow.className == fromClass){
			theRow.style.cursor = 'pointer';
			theRow.className = toClass;
		}
		else{
			theRow.style.cursor = '';
			theRow.className = fromClass;
		}
	}
}

//rollover with layer
function roll(status, elLayr, elId, objOn, objOff)
{	temp = eval("(status) ?" + objOn + ":" + objOff)
	if(dom1)
	{	document.getElementById(elId).setAttribute("src", temp.src)
		//alert(elId + status + temp.src);
	}
	else if(nscp4)
	{	eval("document." + elLayr + ".document." + elId + ".src = temp.src")
	}
	else
	{	eval("document." + elId + ".src = temp.src")
	}
}

//rollover with 2 layers
function roll2(status, elLayr, elLayr2, elId, objOn, objOff)
{	temp = eval("(status) ?" + objOn + ":" + objOff)
	if(dom1)
	{	document.getElementById(elId).setAttribute("src", temp.src)
	}
	else if(nscp4)
	{	eval("document." + elLayr + ".document." + elLayr2 + ".document." + elId + ".src = temp.src")
	}
	else
	{	eval("document." + elId + ".src = temp.src")
	}
}

function changeBackground(thecell,tagetColor) {
	document.getElementById(thecell).style.backgroundColor = tagetColor;
}

/* launch popup window */
function launch(newURL, newName, newFeatures, orgName) {
  var remote = open(newURL, newName, newFeatures);
  if (remote.opener == null)
	remote.opener = window;
  remote.opener.name = orgName;
  return remote;
}

/* toggle the display of two divs */
function displayToggle(divOneName,divTwoName){
	divOne = document.getElementById(divOneName);
	divOne.style.display = (divOne.style.display=='none')? '' : 'none' ;
	divTwo = document.getElementById(divTwoName);
	divTwo.style.display = (divTwo.style.display=='none')? '' : 'none' ;
}

function changeVisibility(element, action)
{
	document.getElementById(element).style.display = action;
}

/**
	Switch element visibility. Return true if element become visible, false otherwise.
*/
function switchVisibility(element)
{
	var curDisp = document.getElementById(element).style.display;
	if (curDisp == "" || curDisp == "inline") {curDisp = "none";} else {curDisp = "inline";}
	document.getElementById(element).style.display = curDisp;
	return curDisp != "none";
}

/* VVL: enable String.trim() funcitonality */
String.prototype.trim = function(){
    return this.replace(/^\s*(.*?)\s*$/g, '$1');
}


function URLEncode(plaintext)
{
    var SAFECHARS = "0123456789" +					// Numeric
                    "ABCDEFGHIJKLMNOPQRSTUVWXYZ" +	// Alphabetic
                    "abcdefghijklmnopqrstuvwxyz" +
                    "-_.!~*'()";					// RFC2396 Mark characters
    var HEX = "0123456789ABCDEF";

    var encoded = "";
    for (var i = 0; i < plaintext.length; i++ ) {
        var ch = plaintext.charAt(i);
        if (ch == " ") {
            encoded += "+";				// x-www-urlencoded, rather than %20
        } else if (SAFECHARS.indexOf(ch) != -1) {
            encoded += ch;
        } else {
            var charCode = ch.charCodeAt(0);
            if (charCode > 255) {
                encoded += "+";
            } else {
                encoded += "%";
                encoded += HEX.charAt((charCode >> 4) & 0xF);
                encoded += HEX.charAt(charCode & 0xF);
            }
        }
    } // for

    return encoded;
}

function URLDecode(encoded)
{
    var HEXCHARS = "0123456789ABCDEFabcdef";
    var plaintext = "";
    var i = 0;
    while (i < encoded.length) {
        var ch = encoded.charAt(i);
        if (ch == "+") {
            plaintext += " ";
            i++;
        } else if (ch == "%") {
                if (i < (encoded.length-2)
                        && HEXCHARS.indexOf(encoded.charAt(i+1)) != -1
                        && HEXCHARS.indexOf(encoded.charAt(i+2)) != -1 ) {
                    plaintext += unescape( encoded.substr(i,3) );
                    i += 3;
                } else {
                    plaintext += "%[ERROR]";
                    i++;
                }
            } else {
            plaintext += ch;
            i++;
            }
        } // while
    return plaintext;
}

function newImage(arg) {
	if (document.images) {
		rslt = new Image();
		rslt.src = arg;
		return rslt;
	}
}

function changeImages() {
	if (document.images && (preloadFlag == true)) {
		for (var i=0; i<changeImages.arguments.length; i+=2) {
			document[changeImages.arguments[i]].src = changeImages.arguments[i+1];
		}
	}
}

function changeInputImages(ctrl, src) {
	ctrl.src = src;
}

var preloadFlag = false;


function checkAllBoxes(ctrlName, flag)
{
	var ctrls = document.getElementsByName(ctrlName);
	for (var i=0; i<ctrls.length; i++) {
		ctrls[i].checked = flag;
	}

}

function getCheckedBoxesNum(ctrlName)
{
	var ctrls = document.getElementsByName(ctrlName);
	var checkedNum = 0;
	for (var i=0; i<ctrls.length; i++) {
		if (ctrls[i].checked) { checkedNum++; }
	}
	return checkedNum;
}

/* Submits form if "Enter" is pressed */
function submitByKey(event) {
  if (event != null) { // Gecko/DOM
    if ( event.keyCode == 13) {
      if ( ! event.target.form.onsubmit || event.target.form.onsubmit() ) {
        event.target.form.submit();
      }
    }
  } else if ( window.event != null ) { // IE events
    if ( window.event.keyCode == 13 ) {
      with ( window.event.srcElement.form ) {
        if ( onsubmit == null || onsubmit() ) {
          submit();
        }
      }
    }
  }
}

function safeHtml(plaintext) {
  var safetext = "";
    for (var i = 0; i < plaintext.length; i++ ) {
      var ch = plaintext.charAt(i);
      if (ch == "<") {
        safetext += "&lt;";
      } else if (ch == ">") {
        safetext += "&gt;";
      } else if (ch == '"') {
        safetext += "&quot;";
      } else if (ch == "&") {
        safetext += "&amp;";
      } else {
        safetext += ch;
      }
    } 
    return safetext;
}

/**
 * Sets the src attribute of an img tag to the default no-image. This is used
 * to handle the onerror for loading images.
 * @param imgEltId DOM ID of the img element.
 * @param size 1=large, 2=medium, 3=small
 */
function setDefaultImage(imgEltId, size){
    var imgElt = document.getElementById(imgEltId);
    if(imgElt != null){
        var url = "/images/common/noimage-";
        switch(size){
            case 1: url += "266x200"; break;
            case 2: url += "105x80"; break;
            case 3: url += "52x40"; break;
            default:break;
        }
        url += ".gif";
        imgElt.setAttribute("src", url);
    }
    return true;
}
