//**********************************************************************
// Tool Tips general functions
// Required:
// - onloadManager.js
// Jeff Chew
//**********************************************************************

// USAGE:
// <img src="image.gif" width="100" height="100" border="0"
//      onmouseover="tooltip.show(event,'Tooltip text goes here')"
//      onmouseout="tooltip.hide()"
//      alt="">

var tooltip = {
	offsetxpoint: 15,
	offsetypoint: 20,

	init: function(){
		divLayer = document.createElement('div');
	    divLayer.id = "tooltipLayer";
        document.body.appendChild(divLayer);

		var tooltipLayer = document.getElementById('tooltipLayer');
	    tooltipLayer.style.display = 			'none';
		tooltipLayer.style.fontFamily = 			'Arial, Helvetica, Sans-serif';
	    tooltipLayer.style.fontSize = 			'11px';
	    tooltipLayer.style.color = 				'#203C70';
	    tooltipLayer.style.position = 			'absolute';
	    tooltipLayer.style.width = 				'250px';
	    tooltipLayer.style.border = 				'2px solid #CEDEE7';
	    tooltipLayer.style.padding = 			'2px';
	    tooltipLayer.style.backgroundColor = 	'#FFFFFF';
	    tooltipLayer.style.zIndex = 				'100';
	    tooltipLayer.style.filter = 				'progid:DXImageTransform.Microsoft.Shadow(color=gray,direction=135)';

		document.onmousemove = tooltip.position;
	},

	hide: function(){
		try{
	        document.getElementById('tooltipLayer').innerHTML = "";
	        document.getElementById('tooltipLayer').style.display = "none";
		}catch(err){

		}
	},

	resetPosition: function(e){
	    var curX,curY;
	    var evt = (window.event) ? window.event : e;
	    var windowScrollTop = (window.event) ? document.documentElement.scrollTop : document.body.scrollTop;
	    var windowHeight = (window.event) ? document.documentElement.clientHeight : document.body.clientHeight;
		var tooltipLayer = document.getElementById('tooltipLayer');
		var tooltipLayerY = tooltipLayer.offsetHeight;
	    if(document.documentElement.clientHeight == 0){
	        windowScrollTop = document.body.scrollTop;
	        windowHeight = document.body.clientHeight;
	    }
	    curX = evt.clientX + document.body.scrollLeft;
	    if(evt.clientY < (windowHeight - tooltipLayerY - 15) && navigator.userAgent.indexOf('MSIE') == -1){
	        curY = evt.clientY + windowScrollTop;
	    }else{
	        curY = evt.clientY + windowScrollTop - tooltipLayerY - 15;
	    }

	    document.getElementById('tooltipLayer').style.left = curX + tooltip.offsetxpoint + "px";
	    document.getElementById('tooltipLayer').style.top = curY + tooltip.offsetypoint + "px";
	},

	position: function(e){
	    if (document.getElementById('tooltipLayer').style.display == "block"){
	        tooltip.resetPosition(e);
	    }
	},

	show: function(e,text){
		try {
	        document.getElementById('tooltipLayer').innerHTML = text;

	        // resets the position of the layer
	        tooltip.resetPosition(e);

	        document.getElementById('tooltipLayer').style.display = "block";
		}catch(err){
			
		}
	},

	show_min: function(e,text){
	
        document.getElementById('tooltipLayer').innerHTML = text;

        // resets the position of the layer
        tooltip.resetPosition(e);

        document.getElementById('tooltipLayer').style.display = "block";
        document.getElementById('tooltipLayer').style.pixelWidth = 120;
	}
}

onloadManager.addFunction('tooltip.init()');