<?php
/*
Plugin Name: Flashy Functionality
Plugin URI: http://www.hqsecure.com
Description: Moves non-theme-specific functions away from functions.php for clarity and portability. | <a href="http://flashalexander.com/wp-content/plugins/flashy-functionality-plugin/Instructions.html" title="Instructions on Plugin Features and Use" target="_blank">Usage Instructions</a>
Author: Flash Alexander
Version: 2.2
Author URI: http://www.flashalexander.com
License: GPL2
*/

/* ======= ADD HELPFUL INFO DASHBOARD WIDGET ========= */
function helpInfo_dash_widget_function() {
include "content/helpful-info.php";
}
function add_dashboard_widgets() {
wp_add_dashboard_widget('new_dash_widget', 'Helpful Information', 'helpInfo_dash_widget_function');
}
add_action('wp_dashboard_setup', 'add_dashboard_widgets' );

// Short Code Clear All Function
// Usage: [clear] - Creates a hard break between elements. Most commonly used to force a new line to begin below an image instead of wrapping around the image.
function clearall() {
	return '<br clear="all" />';
}
add_shortcode('clear', 'clearall');

// Spacer - User Adjustable.
// Usage: Use shortcode [spaceme height=xx] where xx is a number denoting the height one wants in pixels. Default is 5px.
function spacey($atts) {
    extract(shortcode_atts(array(
      "height" => '5',
    ), $atts));

   return '<div style="height: '. $height.'px; width: 100%; display: block;"></div>';
}
add_shortcode('spaceme', 'spacey');


// Custom shortcode for private content visible to site admins and editors, but not the public. Typically used to add notes for others who may be editing the same content.
// Usage: [hidden]This is a personal note that only admins and editors can see![/hidden]
add_shortcode( 'hidden', 'fb_hidden' );
function fb_hidden( $atts, $content = null ) {
	 if ( current_user_can( 'publish_posts' ) )
		return '<div class="privateNotes" style="display: none;">'.$content.'</div>';
	return '';
}

/* ====== HQ Secure Global Internet Scripts to Footer :: www.hqsecure.com ====== */

function custom_clean_head() { 
	remove_action('wp_head', 'wp_print_scripts'); 
	remove_action('wp_head', 'wp_print_head_scripts', 9); 
	remove_action('wp_head', 'wp_enqueue_scripts', 1); 
} 
add_action( 'wp_enqueue_scripts', 'custom_clean_head' );

/* ====== HQ Secure Global Internet Security measures :: www.hqsecure.com ====== */

function explain_less_login_issues(){ return '<span style="font-weight: bold; color: red;">ERROR</span>: Entered credentials are incorrect.';}
add_filter( 'login_errors', 'explain_less_login_issues' );

function flashy_remove_version() {
return '';
}
add_filter('the_generator', 'flashy_remove_version');

// End HQ Secure

/* ============================================================================
   === 					Auto Core Update									===
   === 				Select one and uncomment								===
   === http://codex.wordpress.org/Disabling_Automatic_Background_Updates	===
   ============================================================================
*/
   add_filter( 'allow_major_auto_core_updates', '__return_true' );
   // add_filter( 'allow_dev_auto_core_updates', '__return_true' ); //nightly build updates
   // add_filter( 'allow_minor_auto_core_updates', '__return_false' ); //disable minor core updates
   // add_filter( 'auto_update_core', '__return_false' ); //disable all core updates
   add_filter( 'auto_update_plugin', '__return_true' ); //update plugins
   add_filter( 'auto_update_theme', '__return_true' ); //update themes
   // add_filter( 'automatic_updater_disabled', '__return_true' ); turn off and disable the auto updater to disable all updates.
   
/* ============ Hide Seemingly Worthless Profile Fields ==================== */
add_filter('user_contactmethods','hide_profile_fields',10,1);

function hide_profile_fields( $contactmethods ) {
unset($contactmethods['aim']);
unset($contactmethods['jabber']);
unset($contactmethods['yim']);
return $contactmethods;
}

// Add in Twitter and Facebook...
function fb_contactmethods( $contactmethods ) {
	$contactmethods['twitter'] = 'Twitter';
	$contactmethods['facebook'] = 'Facebook';
	  return $contactmethods;
}
add_filter('user_contactmethods','fb_contactmethods',10,1);

// Call the fields in your author.php or other template files by adding code found in the instructions for this plugin.


/* ========== OPTIONAL MENU AREAS ============ */
   // ====== un-comment to activate ====== //
   // == Add extra menus to your theme == //

/*   
add_action( 'init', 'register_flashy_menus' );

function register_flashy_menus() {
	register_nav_menus(
		array(
			'menu_fb-1' => __( 'Extra Menu 1' ),
			'menu_fb-2' => __( 'Extra Menu 2' )
		)
	);
}
// Call the fields in your template files by adding code found in the instructions for this plugin.
 end comment */
 
 
/* ================= OPTIONAL ================= */
   // ======== un-comment to activate ======== //
   // == Removes attachment page commenting == //

/* 
function filter_media_comment_status( $open, $post_id ) {
	$post = get_post( $post_id );
		if( $post->post_type == 'attachment' ) {
			return false;
		}
	return $open;
}
add_filter( 'comments_open', 'filter_media_comment_status', 10 , 2 );*/

/* // add a favicon to your
	function blog_favicon() {
	echo '<link rel="Shortcut Icon" type="image/x-icon" href="'.get_bloginfo('wpurl').'favicon.ico" />';
	}
	add_action('wp_head', 'blog_favicon');
end comment */

/* ================= OPTIONAL ================= */
   // ======== un-comment to activate ======== //
   // == Removes attachment page commenting == //
   
/*
// custom login logo
function flashy_custom_login_logo() {
    echo '<style type="text/css">
        h1 a { background-image:url(' . get_bloginfo('stylesheet_directory') . '/images/login-logo.png) !important; padding-bottom:0 !important; height:80px !important; width:327px !important; }
    </style>';
}

add_action('login_head', 'flashy_custom_login_logo');

end comment */
?>
